// --- CONFIGURATION DU GRAPHIQUE CHART.JS ---

const ctx = document.getElementById('GraphiqueStrict').getContext('2d');

new Chart(ctx, {
    type: 'bar',
    data: {
        // Toutes les années de 2015 à 2026
        labels: ['2015', '2016', '2017', '2018', '2019', '2020', '2021', '2022', '2023', '2024', '2025', '2026'], 
        datasets: [{
            label: 'Consommation électrique (en TWh)',
            // Les données correspondantes
            data: [200, 230, 270, 310, 350, 400, 430, 460, 580, 720, 890, 1050], 
            
            // Couleurs dynamiques pour raconter une histoire
            backgroundColor: [
                'rgba(54, 162, 235, 0.6)', // 2015 (Bleu)
                'rgba(54, 162, 235, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(54, 162, 235, 0.6)', // 2020
                'rgba(54, 162, 235, 0.6)',
                'rgba(54, 162, 235, 0.6)', // Fin de l'ère classique
                'rgba(255, 159, 64, 0.7)', // 2023 - Arrivée IA (Orange)
                'rgba(255, 159, 64, 0.7)', // 2024
                'rgba(255, 99, 132, 0.8)', // 2025 - Futur critique (Rouge)
                'rgba(255, 99, 132, 0.8)'  // 2026
            ],
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            title: {
                display: true,
                text: 'Évolution et Projection de la consommation mondiale (Impact IA)',
                font: { size: 18 }
            },
            legend: {
                display: true,
                position: 'bottom'
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        return context.raw + ' TWh';
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                title: {
                    display: true,
                    text: 'Térawatt-heures (TWh)'
                }
            }
        }
    }
});

// --- CONFIGURATION DU TABLEAU DATATABLES (EN FRANÇAIS) ---

$(document).ready(function() {
    $('#monTableau').DataTable({
        searching: false,
        language: {
            processing:     "Traitement en cours...",
            search:         "Rechercher&nbsp;:",
            lengthMenu:    "Afficher _MENU_ éléments",
            info:           "Affichage de l'élément _START_ à _END_ sur _TOTAL_ éléments",
            infoEmpty:      "Affichage de l'élément 0 à 0 sur 0 élément",
            infoFiltered:   "(filtré de _MAX_ éléments au total)",
            infoPostFix:    "",
            loadingRecords: "Chargement en cours...",
            zeroRecords:    "Aucun élément à afficher",
            emptyTable:     "Aucune donnée disponible dans le tableau",
            paginate: {
                first:      "Premier",
                previous:   "Précédent",
                next:       "Suivant",
                last:       "Dernier"
            },
            aria: {
                sortAscending:  ": activer pour trier la colonne par ordre croissant",
                sortDescending: ": activer pour trier la colonne par ordre décroissant"
            }
        }
    });
});